/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpMakePKE.c,v 1.6 2001/01/25 22:11:16 jeffc Exp $
____________________________________________________________________________*/
#include "pgpConfig.h"
#include <string.h>

#include "pgpDebug.h"
#include "pgpContext.h"
#include "pgpKeyPriv.h"
#include "pgpMakePKE.h"
#include "pgpErrors.h"
#include "pgpPubKey.h"
#include "pgpUsuals.h"

/*
 * Allocate and return a buffer to hold the ESK packet in *buf, *len.
 *
 * Format of PKE packets:
 *
 *      Offset	Length	Meaning
 *       0	1	Version byte (=2).
 *       1	8	KeyID
 *		 9	1	PK algorithm (1 = RSA)
 *      10	2+?	MPI of PK-encrypted integer
 */
	PGPError
makePke (PGPContextRef context, PGPKeyDBObj const *key,
	PGPByte const *symkey, unsigned symkeylen,
	PgpVersion version, PGPByte **buf, PGPSize *len )
{
	PGPByte *		keybuf;
	PGPSize			keybuflen;
	PGPByte const *	keyIDbytes;
	PGPKeyID		keyID;
	PGPByte			pkalg;
	PGPError		err;

	(void) version;
	pgpAssert( pgpObjectType( key ) == RINGTYPE_KEY ||
			   pgpObjectType( key ) == RINGTYPE_SUBKEY );

	pgpAssert( IsntNull( buf ) );
	pgpAssert( IsntNull( len ) );
	*buf = NULL;
	*len = 0;

	pgpKeyID8 (key, &pkalg, &keyID);
	keyIDbytes = pgpGetKeyIDBytes( &keyID );

	err = pgpKeyEncrypt( (PGPKeyDBObj *)key, symkey, symkeylen,
						 kPGPPublicKeyMessageFormat_PGP, &keybuf, &keybuflen );
	if( IsPGPError( err ) )
		return err;

	*buf = pgpContextMemAlloc( context, keybuflen+10, 0 );
	if( IsNull( *buf ) )
	{
		PGPFreeData( keybuf );
		return kPGPError_OutOfMemory;
	}
	*len = keybuflen + 10;

	/* Okay, build the PKE packet - fixed version number. */
	(*buf)[0] = (PGPByte)PGPVERSION_3;
	/* KeyID */
	pgpCopyMemory( keyIDbytes, (*buf)+1, 8 );
	/* Type */
	(*buf)[9] = pkalg;
	/* Encrypted data */
	pgpCopyMemory( keybuf, (*buf)+10, keybuflen );

	PGPFreeData( keybuf );

	return kPGPError_NoErr;
}




/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
